#pragma once

#include "l2_manager.h"

#include <saas/rtyserver/indexer_core/parsed_document.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>

#include <util/system/rwlock.h>
#include <util/generic/hash.h>

struct TRTYServerConfig;

class TMemoryFAManager;

namespace NRTYServer {
    class IL2ParsedDocumentAccessor {
    public:
        ~IL2ParsedDocumentAccessor() = default;

        virtual TParsedDocument::TPtr GetParsedDocument(ui32 docId) const = 0;
    };

    class TL2ComponentMemoryManagerBase: public TL2ComponentManagerBase, protected IL2ParsedDocumentAccessor {
    public:
        using TL2ComponentManagerBase::TL2ComponentManagerBase;

        void InitInteractions(const NRTYServer::IIndexManagersStorage& storage) override;

    protected:
        TParsedDocument::TPtr GetParsedDocument(ui32 docId) const override;

        const TMemoryFAManager* FullArc = nullptr;

    private:
        IL2ComponentCore::TPtr Core;
    };
}
