#pragma once

#include "l2_core.h"
#include "l2_config.h"

#include <saas/rtyserver/indexer_core/normalizer.h>

class TIndexMetadataProcessor;

namespace NRTYServer {
    class TL2IteratorBase: public TThrRefBase {
    public:
        using TPtr = TIntrusivePtr<TL2IteratorBase>;

    public:
        const TBlob& GetCurrent() const {
            return Current;
        }

        inline ui32 GetDocId() const {
            return DocId;
        }

        inline bool IsValid() const {
            return DocId != Max<ui32>();
        }

        virtual void Next() = 0;

    protected:
        ui32 DocId = Max<ui32>();
        TBlob Current;
    };

    class TL2Normalizer: public NRTYServer::INormalizer {
    public:
        class TImpl;

    public:
        TL2Normalizer(const TString& name, IL2ComponentCore::TPtr core, const TRTYServerConfig& config, const TL2DocStorageParams& arcParams);
        ~TL2Normalizer();

        virtual const char* Name() const override;
        virtual bool AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& /* indexFrq */) const override;
        virtual void Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& /* indexFrq */) const override;

        TMaybe<ui32> GetNormalizerVersion(const TIndexMetadata& meta) const;

    public:
        static TMaybe<ui32> GetNormalizerVersion(const TIndexMetadata& meta, const TString& componentName);
        static void SetNormalizerVersion(TIndexMetadata& meta, const TString& componentName, ui32 version);

    protected:
        TL2IteratorBase::TPtr CreateInputIterator(const TNormalizerContext& context) const;
        THolder<IDocSearchInfoIterator> CreateDocSearchInfoIterator(const TNormalizerContext& context) const;
        ui32 GetMaxDocId(const TNormalizerContext& context) const;
        void RemoveLayer(const TNormalizerContext& context) const;

    private:
        THolder<TImpl> Impl;
        TString DisplayName;
        TString ComponentName;
        TL2DocStorageParams StorageParams;
    };
}
