#pragma once

#include "l2_core.h"
#include <saas/rtyserver/components/fullarchive/light_entity.h>
#include <saas/rtyserver/indexer_core/document_parser.h>

namespace NRTYServer {
    class TL2ComponentParserBase: public TComponentParser {
    protected:
        TString ComponentName;

    private:
        IL2ComponentCore::TPtr Core;

    protected:
        TRTYFullArchiveLightEntity* GetComponentEntity(const TParsingContext& context) const {
            return context.Result.GetComponentEntity<TRTYFullArchiveLightEntity>(ComponentName);
        }

        void WriteRawData(TRTYFullArchiveLightEntity* entity, const TParsingContext& context, TBlob&& data) const {
            if (entity == nullptr) {
                return;
            }

            if (context.Command == NRTYServer::TMessage::DEPRECATED__UPDATE_DOCUMENT && context.DocParseContext.GetLayer() != NRTYServer::NFullArchive::BaseLayer) {
                RestoreIsNeeded(context.Result);
            }

            entity->SetData(std::move(data));
        }

        IL2ComponentCore* GetCore() const {
            return Core.Get();
        }

    public:
        explicit TL2ComponentParserBase(IL2ComponentCore::TPtr core)
            : ComponentName(core->GetName())
            , Core(core)
        {
            CHECK_WITH_LOG(core);
        }
    };
}
