#pragma once

#include <library/cpp/geo/geo.h>

namespace NRTYGeo {
    using TRawPoint = std::pair<float, float>;

    // EGeoType: defines what geometric entity arises from the list of points (SAAS-5724)
    enum class EGeoObjectType {
        // No entity (no hits in the inverted index)
        Void = 0,
        // Union of points
        MultiPoint = 1,
        // Union of rects
        MultiRect = 2, // to be done
        // An object with one single hit in the inverted index
        SingleCompactObject = 3 // to be done
    };

    struct TGeoObject {
        EGeoObjectType Kind = EGeoObjectType::MultiPoint;
        TVector<TRawPoint> GeoPoints;
    };

    struct TGeoLayer {
        ui8 LayerId;
        TGeoObject Object;
    };

    struct TRecord {
        TVector<TGeoLayer> Layers;
    };

    struct TInvKey {
        NGeo::TGeoPoint RectLower;
        NGeo::TGeoPoint RectUpper;

        TInvKey() = default;

        TInvKey(NGeo::TGeoPoint lower, NGeo::TGeoPoint upper)
            : RectLower(lower)
            , RectUpper(upper)
        {
        }
    };

    struct TInvRecord {
        TVector<TInvKey> Keys;
        ui64 KeyPrefix;

        inline bool IsEmpty() const {
            return Keys.empty();
        }
    };
}
