#pragma once

#include "mingeo_core.h"
#include "mingeo_builder.h"
#include "mingeo_normalizer.h"
#include <saas/rtyserver/components/l2/l2_builder.h>
#include <saas/rtyserver/components/l2/l2_normalizer.h>
#include <saas/rtyserver/components/l2/l2_component.h>

namespace NRTYServer {
    class TMinGeoComponent: public TL2Component<TMinGeoCore> {
    public:
        using TBase = TL2Component<TMinGeoCore>;
        using TBase::TBase;

    public:
        TMinGeoComponent(const TRTYServerConfig& config);

    protected:
        virtual bool DoMerge(const TMergeContext& context) const override;

    public:
        virtual bool GetInfoChecker(TInfoChecker& info) const override {
            // This is not Core->GetNormalizerVersion(). Increment it every time when you need
            // the Normalizer to start on the first run of a new build (despite the same Hash in files_info)
            info.Version = 5;
            return true;
        }
    };
}
