#pragma once

#include <saas/rtyserver/components/l2/l2_normalizer.h>

namespace NRTYServer {
    //
    // TMinGeoInvNormalizer
    // @details    This class handles only the inverted part of the Geo index. The uninverted part is still managed
    //             by the base class TL2Normalizer and the callbacks in TMinGeoCore
    //
    class TMinGeoInvNormalizer: public TL2Normalizer {
    public:
        using TL2Normalizer::TL2Normalizer;

    public:
        virtual bool AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& /* indexFrq */) const override;
        virtual void Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& /* indexFrq */) const override;

    private:
        void LoadKpsByDocId(TVector<ui64>& kpsTable, const TNormalizerContext& context) const;
    };
}
