#pragma once

#include <saas/rtyserver/indexer_core/abstract_model.h>
class TMinHashToDocIdConfig;


class TMinHashToDocIdBuilder: public NRTYServer::IIndexComponentBuilder {
public: // NRTYServer::IIndexComponentBuilder
        TMinHashToDocIdBuilder(const TString& fileName, const TString& componentName)
        : NRTYServer::IIndexComponentBuilder(componentName), File(fileName)
    {
    }
    bool Start() override { return true; }
    bool Stop() override { return true; }
    void InitInteractions(const NRTYServer::IIndexBuildersStorage& /*storage*/) override {}
    bool DoClose(const NRTYServer::TBuilderCloseContext& context) override;
    void Index(int threadId, const TParsedDocument& document, const ui32 docId) override;
    NRTYServer::IIndexComponentManager *GetManager() override;

protected:
    TMutex PoolLock;
    TString File;
    ui32 CurrentVersion, MaxBytesInSeconds;
};
