#pragma once

#include <saas/rtyserver/config/config.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <saas/rtyserver/indexer_core/parsed_document.h>
#include <saas/rtyserver/indexer_core/document_parser.h>
#include "builder.h"
#include "manager.h"
#include "config.h"

class TMinHashToDocIdComponent: public NRTYServer::IIndexComponent {

public:
    explicit TMinHashToDocIdComponent(const TRTYServerConfig& config);

    THolder<NRTYServer::IIndexComponentBuilder> CreateBuilder(const NRTYServer::TBuilderConstructionContext& context) const override;
    THolder<NRTYServer::IIndexComponentManager> CreateManager(const NRTYServer::TManagerConstructionContext& context) const override;
    NRTYServer::IParsedEntity::TPtr BuildParsedEntity(NRTYServer::IParsedEntity::TConstructParams& params) const override;
    NRTYServer::IComponentParser::TPtr BuildParser() const override;

    bool CheckAlways() const override {
        return true;
    }

    TString GetName() const override {
        return MINHASH2DOCID_COMPONENT_NAME;
    }

    bool DoMerge(const NRTYServer::TMergeContext& /*rtyContext*/) const override {
        return true;
    }

    bool DoAllRight(const NRTYServer::TNormalizerContext& context) const override;
    void CheckAndFix(const NRTYServer::TNormalizerContext& context) const override;
    const TIndexFiles& GetIndexFiles() const override {
        return IndexFiles;
    }

private:
    const TMinHashToDocIdConfig &ComponentConfig;
    const TRTYServerConfig& Config;
    static TFactory::TRegistrator<TMinHashToDocIdComponent> Registrator;
    TIndexFiles IndexFiles;
};
