#include "config.h"

#include <library/cpp/yconf/conf.h>

bool TMinHashToDocIdConfig::DoCheck() const {
    return KeysPerBucket > 0 && ErrorBits >= 0;
}

void TMinHashToDocIdConfig::DoInit(const TYandexConfig::Section& componentSection) {
    LoadFactor = componentSection.GetDirectives().Value<float>("LoadFactor", 0.9999);
    KeysPerBucket = componentSection.GetDirectives().Value<ui32>("KeysPerBucket", 5);
    ErrorBits = componentSection.GetDirectives().Value<ui32>("ErrorBits", 10);
    Seed = componentSection.GetDirectives().Value<ui32>("Seed", 1);

    MaxBytesPerSecond = componentSection.GetDirectives().Value<ui32>("MaxBytesPerSecond", 0);
}

void TMinHashToDocIdConfig::DoToString(IOutputStream& so) const {
    so << "LoadFactor : " << LoadFactor << Endl;
    so << "KeysPerBucket : " << KeysPerBucket << Endl;
    so << "ErrorBits : " << ErrorBits << Endl;
    so << "Seed : " << Seed << Endl;
}
