#pragma once

#include <saas/library/daemon_base/module/module.h>
#include <saas/rtyserver/config/config.h>

class TMinHashToDocIdConfig: public TPluginConfig<TRTYServerConfig::IComponentConfig> {
private:
    double LoadFactor = 0.9999;
    ui32 KeysPerBucket = 5;
    ui32 MaxBytesPerSecond = 0;    
    ui32 ErrorBits = 10;
    ui32 Seed = 1;

protected:
    virtual bool DoCheck() const;
    virtual void DoInit(const TYandexConfig::Section& componentSection);
    virtual void DoToString(IOutputStream& so) const;

public:

    double GetLoadFactor() const {
        return LoadFactor;
    }

    ui32 GetKeysPerBucket() const {
        return KeysPerBucket;
    }

    ui32 GetErrorBits() const {
        return ErrorBits;
    }

    ui32 GetSeed() const {
        return Seed;
    }

    ui32 GetMaxBytesPerSecond() const {
        return MaxBytesPerSecond;
    }
};
