#pragma once

#include <saas/rtyserver/common/common_rty.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>
#include "library/cpp/minhash/minhash_builder.h"
#include "library/cpp/minhash/table.h"

class IFAManager;

class TMinHashToDocIdManager :
            public IUrlToDocIdManager,
            public NRTYServer::IIndexComponentManager {
public:
    TMinHashToDocIdManager(const TString &componentName)
                    : IIndexComponentManager(componentName)
                    {}
    TMinHashToDocIdManager(const TString &filename, const TString componentName)
                    : IIndexComponentManager(componentName)
                    , FileName(filename)
                    , Size(0) {
    }
    bool IsOpen() const;
public: // IUrlToDocIdManager
    virtual TDocIdCandidate GetIdCandidateByDocInfo(const TDocSearchInfo& info) const override;
    virtual ui32 GetIdByDocInfo(const TDocSearchInfo& info) const override;
    virtual ui32 GetIdByHash(const NSaas::TDocHash& hash) const override;
    virtual bool IsDocCandidateAlwaysVerified() const override;

public: // NRTYServer::IIndexComponentManager
    virtual bool DoOpen() override;
    virtual bool DoClose() override;
    virtual ui32 GetDocumentsCount() const override;
    virtual void InitInteractions(const NRTYServer::IIndexManagersStorage& storage) override;
    virtual bool GetDocInfo(const ui32 docId, NJson::TJsonValue& result) const override;
    virtual bool UpdateDoc(ui32 docId, const TParsedDocument::TPtr doc) override;
    virtual ui32 RemoveDocids(const TVector<ui32>& docids) override;
    virtual ui32 MarkDocIdsForDeleteUnsafe(const TVector<ui32>& docids, ui32 marker) override;
    virtual ERTYSearchResult DoSearch(const TRTYSearchRequestContext& /*context*/, ICustomReportBuilder& /*reportBuilder*/, const IIndexController& /*controller*/) const override;
    bool VerifyIdByHash(ui32 id, const NSaas::TDocHash& hash) const;

protected:

    ui32 GetIdUnsafe(const NSaas::TDocHash& hash) const;
    TString FileName;
    const IDDKManager* DDKManager;
    THolder<NMinHash::TTable<ui32, NMinHash::TChdMinHashFunc>> HashTable;
    ui32 Size;
    static IUrlToDocIdManager::TRemapperFactory::TRegistrator<TMinHashToDocIdManager> RemapperRegistrator;
    bool OpenTableFile();
};

