#include "merger.h"

#include <saas/rtyserver/common/should_stop.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>

bool IOxyMerger::Merge(const NRTYServer::TMergeContext& context, const TRTYServerConfig& config) {
    if (ShouldStop(context.RigidStopSignal))
        return true;
    if (context.Task)
        context.Task->AddProgressInfo(Processor->GetClassName() + " merging...");
    INFO_LOG << "Docs count before merge = " << context.Context.Decoder->GetSize() << " / " << context.Context.Decoder->GetNewDocsCount() << Endl;
    bool result = true;
    try {
        result = DoMerge(context, config);
    }
    catch (...) {
        result = false;
        context.Task->AddProgressInfo(Processor->GetClassName() + " merging...Exception: " + CurrentExceptionMessage());
    }
    if (context.Task)
        context.Task->AddProgressInfo(Processor->GetClassName() + " merging..." + (result ? "OK" : "FAILED"));
    INFO_LOG << "Docs count after merge = " << context.Context.Decoder->GetSize() << " / " << context.Context.Decoder->GetNewDocsCount() << Endl;
    return result;
}

bool IOxyMerger::Initialize(NOxygen::TProcessorPtr processor, const TOxyMergerConfig* config) {
    Processor = processor;
    DoApplyOptions(config);
    return DoInitialize();
}
