#pragma once

#include "merger_config.h"

#include <robot/library/oxygen/indexer/processor/processor/processor.h>

#include <library/cpp/object_factory/object_factory.h>

struct TRTYServerConfig;

namespace NRTYServer {
    struct TMergeContext;
}

class IOxyMerger {
protected:
    NOxygen::TProcessorPtr Processor;

protected:
    virtual bool DoMerge(const NRTYServer::TMergeContext& context, const TRTYServerConfig& config) = 0;
    virtual bool DoInitialize() = 0;
    virtual void DoApplyOptions(const TOxyMergerConfig* /*options*/) {
    }

public:
    using TPtr = TAtomicSharedPtr<IOxyMerger>;
    using TFactory = NObjectFactory::TObjectFactory<IOxyMerger, TString> ;

public:
    virtual ~IOxyMerger() {}

    virtual bool Merge(const NRTYServer::TMergeContext& context, const TRTYServerConfig& config) final;
    virtual bool Initialize(NOxygen::TProcessorPtr processor, const TOxyMergerConfig* config);
};
