#include "update.h"
#include "merger.h"

#include <library/cpp/logger/global/global.h>

bool IOxyUpdater::Update(ui32 docId, const NOxygen::TObjectContext& object) {
    return DoUpdate(docId, object);
}

bool IOxyUpdater::Initialize(NOxygen::TProcessorPtr processor, const TString& indexDir) {
    IndexDir = indexDir;
    TuplesInfo = processor->GetRequiredTuples();
    CHECK_WITH_LOG(!!IOxyMerger::TFactory::Construct(processor->GetClassName()));
    return DoInitialize(processor);
}

EValidationStatus IOxyUpdater::Validate(const NOxygen::TObjectContext& object, NOxygen::TTupleNameSet& handledTuplesNames) const {
    return DoValidate(object, handledTuplesNames);
}
