#pragma once

#include <robot/library/oxygen/indexer/processor/processor/processor.h>

#include <library/cpp/object_factory/object_factory.h>

enum EValidationStatus {
    VS_OK,
    VS_SLOW,
    VS_WRONG_DOCUMENT
};

class IOxyUpdater {
protected:
    TString IndexDir;
    NOxygen::TTuplesUsageInfo TuplesInfo;

protected:
    virtual bool DoUpdate(ui32 docId, const NOxygen::TObjectContext& object) = 0;
    virtual bool DoInitialize(NOxygen::TProcessorPtr processor) = 0;
    virtual EValidationStatus DoValidate(const NOxygen::TObjectContext& object, NOxygen::TTupleNameSet& handledTuplesNames) const = 0;

public:
    using TPtr = TAtomicSharedPtr<IOxyUpdater>;
    using TFactory = NObjectFactory::TObjectFactory<IOxyUpdater, TString>;
public:
    virtual ~IOxyUpdater() {
    }

    const NOxygen::TTuplesUsageInfo& GetTuplesInfo() const {
        return TuplesInfo;
    }

    virtual bool Update(ui32 docId, const NOxygen::TObjectContext& object) final;
    virtual bool Initialize(NOxygen::TProcessorPtr processor, const TString& indexDir);
    virtual EValidationStatus Validate(const NOxygen::TObjectContext& object, NOxygen::TTupleNameSet& handledTuplesNames) const final;
};
