#pragma once

#include <robot/library/oxygen/indexer/processor/collection_base/collection_base.h>

namespace NRTYServer {

    class TCompositeCallback: public NOxygen::ICallbackBase {
    private:
        TVector<NOxygen::TCallbackBasePtr> Callbacks;

    public:
        void AddCallback(NOxygen::TCallbackBasePtr callback) {
            Callbacks.push_back(callback);
        }

    public:
        void BeforeStart(const NOxygen::ITupleProcessor& processor) override {
            for (auto&& callback : Callbacks) {
                callback->BeforeStart(processor);
            }
        }
        void AfterStart(const NOxygen::ITupleProcessor& processor) override {
            for (auto&& callback : Callbacks) {
                callback->AfterStart(processor);
            }
        }
        void BeforeProcess(const NOxygen::ITupleProcessor& processor) override {
            for (auto&& callback : Callbacks) {
                callback->BeforeProcess(processor);
            }
        }
        void AfterProcess(const NOxygen::ITupleProcessor& processor) override {
            for (auto&& callback : Callbacks) {
                callback->AfterProcess(processor);
            }
        }
        void BeforeFinish(const NOxygen::ITupleProcessor& processor) override {
            for (auto&& callback : Callbacks) {
                callback->BeforeFinish(processor);
            }
        }
        void AfterFinish(const NOxygen::ITupleProcessor& processor) override {
            for (auto&& callback : Callbacks) {
                callback->AfterFinish(processor);
            }
        }
    };
}
