#pragma once

#include "config.h"
#include <saas/rtyserver/components/oxy/processors/tuples_list_and_filters.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <saas/rtyserver/indexer_core/normalizer.h>
#include <saas/rtyserver/components/generator/component.h>
#include <saas/rtyserver/config/const.h>
#include <saas/rtyserver/config/globals.h>

class TOXYIndexComponent : public TBaseIndexComponent,
                           public TTuplesListsAndFilters::ITuplesListsAndFiltersInitializer
{
public:
    TOXYIndexComponent(const TRTYServerConfig& config);

    TString GetName() const override { return OXY_COMPONENT_NAME; }

    THolder<NRTYServer::IIndexComponentBuilder> CreateBuilder(const NRTYServer::TBuilderConstructionContext& context) const override;
    THolder<NRTYServer::IIndexComponentManager> CreateManager(const NRTYServer::TManagerConstructionContext& context) const override;

    NRTYServer::IComponentParser::TPtr BuildParser() const override;
    NRTYServer::IParsedEntity::TPtr BuildParsedEntity(NRTYServer::IParsedEntity::TConstructParams& params) const override;

    bool DoAllRight(const NRTYServer::TNormalizerContext& context) const override;
    void CheckAndFix(const NRTYServer::TNormalizerContext& context) const override;
    bool CheckAlways() const override;

    bool HasIndexFiles(const TString& path) const override;
    bool IsFinalIndex(const TString& path) const override;
    bool IsEmptyIndex(const TString& path) const override;
    void CheckTuples(const TString& tuples) const;
    bool CheckConfig() const override;

    const TTuplesListsAndFilters::TTupleNameSet* GetFilterTuples(const TString& layer) const;
    const TTuplesListsAndFilters::TTupleNameSet& GetFilterTuples() const;

    THolder<TPruningConfig::ICalcer> CreatePruningCalcer(const NRTYServer::IIndexManagersStorage* managers) const override;
    const TRTYServerConfig& GetConfig() const override;

protected:
    NOxygen::TTuplesUsageInfo BuildTuplesInfo(bool forMerger) const override;
    TTuplesListsAndFilters::TTupleNameSet GetAdditionalRequiredTuples() const override;
    TTuplesListsAndFilters::TTupleNameSet GetAdditionalRequiredMergeTuples() const override;
    bool DoMergeMeta(const NRTYServer::TMergeContext& context) const override;
    bool DoMerge(const NRTYServer::TMergeContext& context) const override;

    NOxygen::TTuplesUsageInfo BuildTuplesInfo(const NOxygen::TOxygenOptions& oxygenOptions, bool merger) const;
    const NOxygen::TOxygenOptions& GetOxygenOptions(const TString& realmName) const;

private:
    const TRTYOxyConfig& ComponentConfig;
    THolder<TTuplesListsAndFilters> TuplesListsAndFilters;
    NRTYServer::TNormalizersCollection Normalizers;

private:
    static TFactory::TRegistrator<TOXYIndexComponent> Registrator;
};

