#pragma once

#include <saas/library/daemon_base/module/module.h>
#include <saas/rtyserver/config/config.h>

class TRTYOxyConfig: public TPluginConfig<TRTYServerConfig::IComponentConfig> {
public:
    enum TFilterType {
        NO,
        FOR_INDEX,
        FOR_MERGE_COMPLEMENT,
        FOR_MERGE,
        FOR_SAVE,
        COUNT_FILTER_TYPES
    };

    typedef THashSet<TString> TLayersSet;
    typedef THashSet<TString> TTupleNameSet;
    typedef THashMap<TFilterType, TLayersSet> TLayersSetByFilterType;
    typedef THashSet<TString> TDbgOxyFlags;

public:
    TRTYOxyConfig();

    const TLayersSetByFilterType& GetLayers() const {
        return ArchiveLayers;
    }
    const TTupleNameSet GetAdditionalRequiredTuples() const {
        return AdditionalRequiredTuples;
    }
    const TTupleNameSet GetAdditionalRequiredMergeTuples() const {
        return AdditionalRequiredMergeTuples;
    }

    const TDbgOxyFlags& GetDbgOxyFlags() const {
        return DbgOxyFlags;
    }

protected:
    virtual bool DoCheck() const;
    virtual void DoInit(const TYandexConfig::Section& componentSection);
    virtual void DoToString(IOutputStream& so) const;

private:
    TLayersSetByFilterType ArchiveLayers;

    TTupleNameSet AdditionalRequiredTuples;
    TTupleNameSet AdditionalRequiredMergeTuples;
    TDbgOxyFlags DbgOxyFlags;

private:
    static TRTYServerConfig::IComponentConfig::TFactory::TRegistrator<TRTYOxyConfig> ConfigRegistrator;
};
