#pragma once

#include <kernel/doom/adaptors/read_adaptors.h>
#include <kernel/doom/offroad_attributes_wad/offroad_attributes_wad_io.h>
#include <kernel/doom/offroad_wad/offroad_ann_wad_io.h>
#include <kernel/doom/yandex/yandex_io.h>

//
// NDoom types for Wrangling (used in normalizers and tests)
//
// nb: All the NDoom IO references (both includes and the linker dependencies) of oxy should be localized here!
//
namespace NDoom {
namespace NRTYServer {

    //---------------------------------------------------------------------------------------------------
    // High level IO

    struct TIndexAttrsFilter {
        bool operator()(const TStringBuf& key) const {
            TEmptyPrefixKeyFilter filter;
            return !filter(key);
        }
    };

    using TTextWadFilter = NDoom::TEmptyPrefixExceptTelKeyFilter;

    template<class TFilter>
    using TYandexReader =  NDoom::THitTransformingIndexReader<NDoom::TIdentityHitTransformation,
            NDoom::TKeyFilteringIndexReader<TFilter, NDoom::TYandexIo::TReader>>;

    using TTextWadIo = NDoom::TOffroadAnnWadIoSortedMultiKeys;
    using TAttrsWadIo = NDoom::TOffroadAttributesIo;
    using TIndexAttrsIo = NDoom::TYandexIo;
}
}

