#pragma once

#include <saas/rtyserver/components/oxy/doom/ki_doom_io.h>
#include <saas/rtyserver/components/oxy/doom/offroad_wad_doc_writer.h>
#include <kernel/doom/offroad_key_wad/offroad_key_wad_io.h>
#include <kernel/doom/offroad_doc_wad/offroad_doc_wad_io.h>

namespace NDoom {
namespace NRTYServer {
    //---------------------------------------------------------------------------------------------------
    // Low-level IO for accessing keyinv.wad components

    // Here we had to create a matching TDocIo by copying types from TOffroadAnnWadIoSortedMultiKeys:
    //     TOffroadDocWadIo: template <EWadIndexType indexType, class Hit, class Vectorizer, class Subtractor,
    //           class PrefixVectorizer, EStandardIoModel defaultHitModel, EOffroadDocCodec codec = AdaptiveDocCodec>
    //     searcher's IO: TOffroadWadIo<TReqBundleHit, TReqBundleHitVectorizer, TReqBundleHitSubtractor,
    //           TReqBundleHitPrefixVectorizer, DefaultAnnSortedMultiKeysKeyIoModel, DefaultAnnSortedMultiKeysHitIoModel, true>;
    //
    using TTextWadDocIo = TOffroadDocWadIo<FactorAnnIndexType, TReqBundleHit, TReqBundleHitVectorizer, TReqBundleHitSubtractor,
            TReqBundleHitPrefixVectorizer, DefaultAnnSortedMultiKeysHitIoModel>;
    using TTextWadKeyIo = TOffroadFactorAnnKeyWadIo;

    // custom writer, created as above from TOffroadAnnWadIoSortedMultiKeys. Non-decoded keys.
    using TTextWadWriter = TOffroadWadDocWriter<FactorAnnIndexType, TReqBundleHit, TReqBundleHitVectorizer, TReqBundleHitSubtractor,
            TReqBundleHitPrefixVectorizer, NOffroad::TKeyFullPrefixGetter>;
}
}
