#pragma once

#include <saas/rtyserver/components/oxy/abstract/merger.h>
#include <robot/library/oxygen/indexer/processor/herf/herf.h>

class TOxyHErfMockMerger : public IOxyMerger {
private:
    static TFactory::TRegistrator<TOxyHErfMockMerger> Registrator;

    bool DisableRegHerfMerge = false;
public:
    bool DoMerge(const NRTYServer::TMergeContext& /*context*/, const TRTYServerConfig& /*config*/) override {
        // do nothing (actual merge is handled by the old processor, which is reconfigured a bit)
        return true;
    }

    void DoApplyOptions(const TOxyMergerConfig* options) override {
        if (options && options->UseExternalRegHostErfMerger) {
            DisableRegHerfMerge = true;
        }
    }

    bool DoInitialize() override {
        if (!DisableRegHerfMerge)
            return false;

        NOxygen::THErfProcessor* proc = dynamic_cast<NOxygen::THErfProcessor*>(Processor.Get());
        if (!proc)
            return false;

        proc->SetDisableRegHerf(true);
        return true;
    }
};
