#include "merger.h"

#include <saas/rtyserver/model/component.h>

#include <robot/library/oxygen/indexer/processor/keyinv/keyinv.h>

bool TOxyKeyInvMerger::DoMerge(const NRTYServer::TMergeContext& context, const TRTYServerConfig&) {
    TRTYMerger rtyMerger(context.RigidStopSignal, TRTYMerger::otKI);
    // Lock indexation on callback after archive merge
    TRTYMerger::TContext mc(context.Context);
    mc.AdditionalSuffixIndexName = Prefix;
    mc.IgnoreNoAttrs = true;
    mc.StripKeys = StripKeys;
    mc.UniqueHits = UniqueHits;
    return rtyMerger.MergeIndicies(mc);
}

bool TOxyKeyInvMerger::DoInitialize() {
    NOxygen::TKeyInvProcessor* proc = dynamic_cast<NOxygen::TKeyInvProcessor*>(Processor.Get());
    CHECK_WITH_LOG(proc);
    Prefix = TFsPath(proc->GetPrefix()).GetName();
    StripKeys = proc->GetStripKeys();
    UniqueHits = proc->GetUniqueHits();
    if (!Prefix.StartsWith("index")) {
        ERROR_LOG << "Incorrect prefix for keyinv merger: " << Prefix << Endl;
        return false;
    } else {
        INFO_LOG << "Prefix for keyinv merger: " << Prefix << Endl;
    }
    Prefix = Prefix.substr(5);
    return true;
}

TOxyKeyInvMerger::TFactory::TRegistrator<TOxyKeyInvMerger> TOxyKeyInvMerger::Registrator("TKeyInvProcessor");
TOxyKeyInvMerger::TFactory::TRegistrator<TOxyKeyInvMerger> TOxyKeyInvMerger::RegistratorAttrs("TKeyInvAttrsProcessor");
