#pragma once

#include "merger.h"
#include <saas/rtyserver/model/index.h>

struct TOxyKeyInvWadPossibleModes;

class TOxyKeyInvWadMerger final: public IOxyMerger {
private:
    static TFactory::TRegistrator<TOxyKeyInvWadMerger> KeyInvRegistrator;
    static TFactory::TRegistrator<TOxyKeyInvWadMerger> AttrsRegistrator;
public:
    virtual bool DoInitialize() override {
        return true;
    }

    virtual bool DoMerge(const NRTYServer::TMergeContext& context, const TRTYServerConfig& config) override;
private:
    static void RebuildIndex(const TFsPath& dir, const TString& realmName, const TRTYServerConfig& config, const TOxyKeyInvWadPossibleModes& possible);
};

//TODO:(yrum) remove class TOxyKeyInvWrangleMerger
class TOxyKeyInvWrangleMerger final: public TOxyKeyInvMerger {
private:
    static TFactory::TRegistrator<TOxyKeyInvWrangleMerger> Registrator;
public:
    virtual bool DoInitialize() override;
    virtual bool DoMerge(const NRTYServer::TMergeContext& context, const TRTYServerConfig&) override;

public:
    static void WrangleTextWad(const TString& slaveOutputPrefix, const TString& wadOutputPrefix); // public, to write tests
};
