#pragma once

#include "abstract/update.h"

#include <saas/rtyserver/components/generator/manager.h>

namespace NOxygen {
    class TOxygenOptions;
}

class TOXYIndexManager: public TBaseIndexManager {
public:
    TOXYIndexManager(const NRTYServer::TManagerConstructionContext& context, TVector<IOxyUpdater::TPtr> updaters, const TString& componentName);
    virtual bool DoOpen() override;
    virtual bool DoClose() override;
    virtual i64  PrnValue(ui32 docid, i64 defaultValue) const override;
    virtual void InitInteractions(const NRTYServer::IIndexManagersStorage& storage) override;
    virtual bool IsRemoved(ui32 docid) const override;

    virtual bool UpdateDoc(ui32 docId, const TParsedDocument::TPtr doc) override;

protected:
    virtual ui32 GetDeletedDocumentsCount() const override;
    virtual ui32 GetDocumentsCountImpl() const override;
    virtual ui32 DoRemoveDocids(const TVector<ui32>& docids) override;

private:
    bool HasPruning() const;

private:
    TVector<IOxyUpdater::TPtr> Updaters;
    THolder<TFileMap> FileIndexPrn;
    THolder<TFileMappedArray<float>> PrnArray;
    const TBaseGeneratorManager* FA;
    const NOxygen::TOxygenOptions* OxygenOptions;
};
