#include "interface.h"

#include <kernel/walrus/advmerger.h>

#include <library/cpp/logger/global/global.h>

#include <search/panther/indexing/counts_to_panther/options.h>
#include <robot/library/oxygen/indexer/processor/protos/config.pb.h>

bool NRTYServer::IPantherImplementation::MergeCountsAndPanther(
    TSimpleSharedPtr<TAdvancedMergeTask> task,
    const TRTYMergerContextBase& mergeCtx,
    const NPanther::TCountsToPantherOptions& options,
    const THashSet<TString>& frequentKeys,
    const std::atomic<bool>* stop /*= nullptr */)
{
    Y_UNUSED(frequentKeys);
    Y_UNUSED(mergeCtx);
    CHECK_WITH_LOG(!task->Outputs.empty());
    TAdvancedIndexMerger merger(task, stop, true);
    if (!merger.Run()) {
        ERROR_LOG << "Cannot merge indexcounts*" << Endl;
        return false;
    }

    for (auto&& output : task->Outputs) {
        const TFsPath root = TFsPath(output.FilePrefix).Parent();
        ConvertCountsToPanther(root / "indexcounts.", root / "indexpanther.", options);
    }
    return true;
}

void NRTYServer::IPantherImplementation::ConvertPantherOptions(
        const NOxygen::TCountsToPantherOptions& config,
        NPanther::TCountsToPantherOptions& options) {
    const NPanther::EPantherVersion version = config.HasVersion() ? FromString<NPanther::EPantherVersion>(config.GetVersion()) : NPanther::PantherV0_1;
    options.MinBigramRelevance = config.GetMinBigramRelevance();
    options.MinUnigramRelevance = config.GetMinUnigramRelevance();
    options.RelevanceMultiplier = config.GetRelevanceMultiplier();
    if (config.HasTopKishkaLength()) {
        options.TopKishkaLength = config.GetTopKishkaLength();
    }
    options.CheckPantherFiles = config.GetCheckPantherFiles();
    options.UseYndexPanther = config.GetUseYndexPanther();
    if (config.HasMinKishkaLength())
        options.MinKishkaLength = config.GetMinKishkaLength();
    if (config.HasMaxKishkaLength())
        options.MaxKishkaLength = config.GetMaxKishkaLength();
    if (config.HasSuperLemmerVersion())
        options.SuperLemmerVersion = FromString<NSuperLemmer::ESuperLemmerVersion>(config.GetSuperLemmerVersion());
    options.Version = version;
}

NOxygen::TProcessorPtr NRTYServer::IPantherImplementation::CreateBoosterProcessor(const TFsPath& outputPrefix, const NOxygen::TCountsToPantherOptions& options) const {
    Y_UNUSED(outputPrefix);
    Y_UNUSED(options);
    return NOxygen::TProcessorPtr();
}
