#pragma once

#include <kernel/doom/enums/namespace.h>

#include <library/cpp/object_factory/object_factory.h>
#include <robot/library/oxygen/indexer/processor/processor/processor.h>
#include <search/panther/custom/version/panther_version.h>

#include <util/generic/string.h>
#include <util/generic/ptr.h>

struct TAdvancedMergeTask;
struct TRTYMergerContextBase;

namespace NPanther {
    struct TCountsToPantherOptions;
}

namespace NOxygen {
    class TCountsToPantherOptions;
}

namespace NRTYServer {
    class IPantherImplementation {
    public:
        using TFactory = NObjectFactory::TObjectFactory<IPantherImplementation, NPanther::EPantherVersion>;

    public:
        virtual ~IPantherImplementation() {}

        virtual void ConvertCountsToPanther(const TString& countsPrefix, const TString& pantherPrefix, const NPanther::TCountsToPantherOptions& options) const = 0;
        virtual bool MergeCountsAndPanther(
            TSimpleSharedPtr<TAdvancedMergeTask> task,
            const TRTYMergerContextBase& mergeCtx,
            const NPanther::TCountsToPantherOptions& options,
            const THashSet<TString>& frequentKeys,
            const std::atomic<bool>* stop = nullptr
        );

        virtual NOxygen::TProcessorPtr CreateBoosterProcessor(const TFsPath& outputPrefix, const NOxygen::TCountsToPantherOptions& options) const;

    public:
        static void ConvertPantherOptions(const NOxygen::TCountsToPantherOptions& config, NPanther::TCountsToPantherOptions& options);
    };
}
