#pragma once

#include <robot/library/oxygen/indexer/processor/panther_counts/panther_counts.h>

namespace NRTYServer {
    class IPantherImplementation;

    class TPantherProcessor: public NOxygen::TPantherCountsProcessor {
    public:
        TPantherProcessor(
            const TFsPath& indexDirectory,
            const TFsPath& tmpDir,
            const NOxygen::TRTYPantherOptions& pantherOptions,
            TAtomicSharedPtr<IThreadPool> taskPool
        );
        ~TPantherProcessor();

        virtual TString GetClassName() const override;
        virtual NOxygen::TTuplesUsageInfo GetRequiredTuples() const override;

        virtual void Start() override;
        virtual NThreading::TFuture<NOxygen::TReturnObjectContext> Process(NOxygen::TObjectContext objectContext, ui32 tmpObjectId) override;
        virtual void Finish(const NOxygen::TDocIdMap* map) override;

    private:
        const TFsPath IndexDirectory;
        const NOxygen::TPantherCountsMapperConfig MapperConfig;
        const NOxygen::TCountsToPantherOptions CountsToPantherOptions;

        TAtomicSharedPtr<IThreadPool> TaskPool;
        THolder<IPantherImplementation> Implementation;
        NOxygen::TProcessorPtr Booster; // slave processor for some implementation
        ui32 MaxDocId = 0;
    };
}
