#pragma once

#include <saas/rtyserver/indexer_core/parsed_document.h>
#include <saas/rtyserver/indexer_core/document_parser.h>
#include <saas/rtyserver/components/generator/parsed_entity.h>
#include "abstract/update.h"

class TOXYIndexComponent;

class TOXYParsedEntity: public TBaseGeneratorParsedEntity {
public:
    TOXYParsedEntity(TConstructParams& params);

    virtual void MergeToProto(NRTYServer::TParsedDoc& pd, const NRTYServer::TDocSerializeContext& context) const;
    virtual bool FillFromProto(const NRTYServer::TParsedDoc& pd, const NRTYServer::TDocParseContext& context);

protected:
    virtual void DoApplyPatch(const TParsedDocument& doc);
    static void DoFilterTuples(NRealTime::TIndexedDoc& doc, const NRTYServer::TDocSerializeContext& context);
};

class TOXYComponentParser : public TBaseGeneratorEntityParser {
public:
    TOXYComponentParser(const NRTYServer::IIndexComponent& component, TVector<IOxyUpdater::TPtr> updaters);

    virtual void Parse(TParsingContext& context) const;

private:
    bool IsFastUpdate(TParsingContext& context) const;

private:
    const TOXYIndexComponent& OxygenComponent;
    TVector<IOxyUpdater::TPtr> Updaters;
};
