#include "processor_profiler.h"

void NRTYServer::TProcessorProfiler::BeforeStart(const NOxygen::ITupleProcessor& processor) {
    ProcessingTimes[&processor].Name = GetProcessorDescription(processor);
}

void NRTYServer::TProcessorProfiler::AfterStart(const NOxygen::ITupleProcessor& /*processor*/) {
}

void NRTYServer::TProcessorProfiler::BeforeProcess(const NOxygen::ITupleProcessor& /*processor*/) {
    StartTime = Now();
}

void NRTYServer::TProcessorProfiler::AfterProcess(const NOxygen::ITupleProcessor& processor) {
    ProcessingTimes[&processor].Process += (Now() - StartTime);
}

void NRTYServer::TProcessorProfiler::BeforeFinish(const NOxygen::ITupleProcessor& /*processor*/) {
    StartTime = Now();
}

void NRTYServer::TProcessorProfiler::AfterFinish(const NOxygen::ITupleProcessor& processor) {
    ProcessingTimes[&processor].Finish += (Now() - StartTime);
}

TString NRTYServer::TProcessorProfiler::GetProcessorDescription(const NOxygen::ITupleProcessor& processor) const {
    TString result = processor.GetClassName();
    auto requiredTuples = processor.GetRequiredTuples();
    for (auto&& tuple : requiredTuples.GetFullTuplesSet()) {
        result += "," + tuple;
    }
    return result;
}
