#pragma once

#include <robot/library/oxygen/indexer/processor/collection_base/collection_base.h>

#include <util/datetime/base.h>
#include <util/generic/map.h>

namespace NRTYServer {

    // not thread-safe
    class TProcessorProfiler: public NOxygen::ICallbackBase {
    public:
        struct TProcessorTime {
            TString Name;
            TDuration Process;
            TDuration Finish;
        };

        using TProcessorTimes = TMap<const void*, TProcessorTime>;

    private:
        TProcessorTimes ProcessingTimes;

        TInstant StartTime;

    public:
        const TProcessorTimes& GetProcessingTimes() const {
            return ProcessingTimes;
        }

    public: // NOxygen::ICallbackBase
        void BeforeStart(const NOxygen::ITupleProcessor& processor) override;
        void AfterStart(const NOxygen::ITupleProcessor& processor) override;
        void BeforeProcess(const NOxygen::ITupleProcessor& processor) override;
        void AfterProcess(const NOxygen::ITupleProcessor& processor) override;
        void BeforeFinish(const NOxygen::ITupleProcessor& processor) override;
        void AfterFinish(const NOxygen::ITupleProcessor& processor) override;

    private:
        TString GetProcessorDescription(const NOxygen::ITupleProcessor& processor) const;
    };
}
