#pragma once

#include <robot/library/oxygen/indexer/processor/processor/processor.h>

namespace NRTYServer {
    class THistogramProcessor : public NOxygen::ITupleProcessor {
    public:
        struct TEntity {
            TString TupleName;
            ui64 Period;
        };
        using TEntities = TVector<TEntity>;

    public:
        THistogramProcessor(const TEntities& entities, const TString& outputDir);

        virtual TString GetClassName() const override {
            return "THistogramProcessor";
        }
        virtual NOxygen::TTuplesUsageInfo GetRequiredTuples() const override {
            return Tuples;
        }

        virtual void Start() override;
        virtual NThreading::TFuture<NOxygen::TReturnObjectContext> Process(NOxygen::TObjectContext objectContext, ui32 tmpObjectId) override;
        virtual void Finish(const NOxygen::TDocIdMap* map) override;

    private:
        const TEntities Entities;
        const TString OutputDirectory;

        NOxygen::TTuplesUsageInfo Tuples;
        TVector<TVector<ui64>> Values;
    };
}
