#include "precomp_hits.h"

#include <util/folder/path.h>

namespace NOxygen {

    TPrecomputedHitsProcessor::TPrecomputedHitsProcessor(const NOxygen::TPrecomputedHitsOptions& precomputedHitsOptions, const TString& outputDir)
        : OutputDir(outputDir)
    {
        for (ui32 i = 0; i < precomputedHitsOptions.TasksSize(); ++i) {
            HitsCalcer.push_back(new THitsCalculator);
            HitsCalcer.back()->SetCallback(&Callback);
            TString queriesFilePath = precomputedHitsOptions.GetTasks(i).GetQueriesPath();
            TString outputFileName = precomputedHitsOptions.GetTasks(i).GetOutputPath();
            Y_ENSURE(NFs::Exists(queriesFilePath), "can't find file " + queriesFilePath);
            Y_ENSURE(!!outputFileName, "Incorrect output file name");

            HitsCalcer.back()->Queries = queriesFilePath;
            HitsCalcer.back()->Out = OutputDir + "/" + outputFileName;
            HitsCalcer.back()->YName = OutputDir + "/index";
        }
    }

    TTupleNameSet TPrecomputedHitsProcessor::GetRequiredTuples() const {
        return TTupleNameSet();
    }

    void TPrecomputedHitsProcessor::Start() {
    }

    TReturnObjectContext TPrecomputedHitsProcessor::Process(TObjectContext /*processContext*/, ui32 /*tmpObjectId*/) {
        return TReturnObjectContext::Ok;
    }

    void TPrecomputedHitsProcessor::Finish(const TDocIdMap* /*map*/) {
        for (ui32 i = 0; i < HitsCalcer.size(); ++i) {
            ui32 result = HitsCalcer[i]->Execute();
            Y_ENSURE(result == 0, "Incorrect result: " + ToString(result) + " for task N" + ToString(i));
        }
    }
}
