#pragma once

#include <robot/library/oxygen/indexer/processor/processor/processor.h>
#include <robot/library/oxygen/indexer/processor/protos/config.pb.h>
#include <util/stream/file.h>
#include <util/folder/dirut.h>
#include <yweb/webutil/porno2/hits_calculator/hits_calculator.h>
#include <saas/library/daemon_base/metrics/logging.h>

namespace NOxygen {

    class TPrecomputedHitsProcessor: public ITupleProcessor {
    private:
        class THitsCalculatorCallbackRTY: public THitsCalculator::ICallback {
            virtual void Error(ui32 code, const char* message) {
                ERROR_LOG << "Incorrect hits calculation : " << code << "/" << (TString)message << Endl;
            }

            virtual void Warning(const char* message) {
                WARNING_LOG << "Incorrect hits calculation : " << (TString)message << Endl;
            }
        };

        const TString OutputDir;
        THitsCalculatorCallbackRTY Callback;
        TVector<TAutoPtr<THitsCalculator>> HitsCalcer;
    public:
        TPrecomputedHitsProcessor(const NOxygen::TPrecomputedHitsOptions& precomputedHitsOptions, const TString& outputDir);

        ~TPrecomputedHitsProcessor() {}

        TString GetClassName() const override {
            return "TPrecomputedHitsProcessor";
        }

        virtual TTupleNameSet GetRequiredTuples() const override;

        // ITupleProcessor
        void Start() override;
        TReturnObjectContext Process(TObjectContext objectContext, ui32 tmpObjectId) override;
        void Finish(const TDocIdMap* map) override;
    };

} // namespace NOxygen
