#pragma once

#include <robot/library/oxygen/indexer/processor/processor/processor.h>
#include <robot/library/oxygen/indexer/processor/protos/config.pb.h>

namespace NOxygen {

    class TShardConfProcessor: public ITupleProcessor {
    private:
        const TString OutputDir;
        const TString ShardName;
        const TInstant Timestamp;
    public:
        TShardConfProcessor(const NOxygen::TShardConfOptions& shardConfOptions, const TString& outputDir)
            : OutputDir(outputDir)
            , ShardName(shardConfOptions.GetShardName())
            , Timestamp(TInstant::Seconds(shardConfOptions.GetTimestamp()))
        {
        }

        virtual TString GetClassName() const override {
            return "TShardConfProcessor";
        }
        virtual TTuplesUsageInfo GetRequiredTuples() const override {
            return TTuplesUsageInfo();
        }

        // ITupleProcessor
        virtual void Start() override {
        }
        virtual TFuture<TReturnObjectContext> Process(TObjectContext /*objectContext*/, ui32 /*tmpObjectId*/) override {
            return TReturnObjectContext::FutureOk;
        }
        virtual void Finish(const TDocIdMap* map) override;
    };

} // namespace NOxygen
