#include "static_data.h"

#include <saas/library/sandbox/recipe_download/download.h>

#include <google/protobuf/text_format.h>

#include <util/folder/dirut.h>
#include <util/folder/path.h>
#include <util/stream/file.h>

namespace NOxygen {

    TStaticDataProcessor::TStaticDataProcessor(const NOxygen::TStaticDataOptions& staticDataOptions, const TString& outputDir)
        : OutputDir(outputDir)
    {
        Recipe = NSaas::BuildRecipeFromStaticDataOptions(staticDataOptions);
    }

    TTuplesUsageInfo TStaticDataProcessor::GetRequiredTuples() const {
        return TTuplesUsageInfo();
    }

    void TStaticDataProcessor::Start() {
        NSaas::DownloadRecipeFiles(Recipe, OutputDir, true, false, false, false);
    }

    TFuture<TReturnObjectContext> TStaticDataProcessor::Process(TObjectContext /*processContext*/, ui32 /*tmpObjectId*/) {
        return TReturnObjectContext::FutureOk;
    }

    void TStaticDataProcessor::Finish(const TDocIdMap* /*map*/) {
    }
}
