#pragma once

#include <robot/library/oxygen/indexer/processor/processor/processor.h>

#include <robot/library/oxygen/indexer/processor/protos/config.pb.h>
#include <robot/library/oxygen/base/protos/recipe.pb.h>

namespace NOxygen {

    class TStaticDataProcessor: public ITupleProcessor {
    private:
        NOxygen::TRecipeConfigProto Recipe;
        const TString OutputDir;
    public:
        TStaticDataProcessor(const NOxygen::TStaticDataOptions& staticDataOptions, const TString& outputDir);
        ~TStaticDataProcessor() {}

        TString GetClassName() const override {
            return "TStaticDataProcessor";
        }

        virtual TTuplesUsageInfo GetRequiredTuples() const override;

        // ITupleProcessor
        void Start() override;
        TFuture<TReturnObjectContext> Process(TObjectContext objectContext, ui32 tmpObjectId) override;
        void Finish(const TDocIdMap* map) override;
    };

} // namespace NOxygen
