#pragma once

#include "tuples_list_and_filters.h"
#include <robot/library/oxygen/indexer/processor/processor/processor.h>

namespace NOxygen {

    class TTuplesListProcessor: public ITupleProcessor {
    public:

        class TTupleNameSetByLayers: public THashMap<TString, TTupleNameSet> {
        private:
        public:

            TTupleNameSetByLayers() {

            }

            TTupleNameSetByLayers(const TTupleNameSet& tuples, const TTuplesListsAndFilters& filters);

            void Intersect(const TTupleNameSetByLayers& tuplesSet);
        };

        TTuplesListProcessor(const TString& outputDir, const TTuplesListsAndFilters& filtersAndLists);
        virtual TTuplesUsageInfo GetRequiredTuples() const override;
        // ITupleProcessor
        void Start() override;
        TFuture<TReturnObjectContext> Process(TObjectContext objectContext, ui32 tmpObjectId) override;
        void Finish(const TDocIdMap* map) override;
        static bool LoadTuplesList(const TString& dir, TTupleNameSetByLayers& tuples);
        static void SaveTuplesList(const TString& dir, const TTupleNameSetByLayers& tuples);

        TString GetClassName() const override {
            return "TTuplesListProcessor";
        }
    private:
        bool Initialized;
        const TString OutputDir;
        TTupleNameSet Tuples;
        const TTuplesListsAndFilters& FiltersAndLists;
    };

} // namespace NOxygen
