#pragma once

#include <util/generic/hash.h>
#include <util/generic/hash_set.h>
#include <util/generic/vector.h>
#include <util/generic/string.h>
#include <saas/rtyserver/components/oxy/config.h>
#include <robot/library/oxygen/indexer/processor/processor/processor.h>

class TTuplesListsAndFilters {
public:
    typedef TRTYOxyConfig::TLayersSetByFilterType TLayersSetByFilterType;
    typedef TRTYOxyConfig::TTupleNameSet TTupleNameSet;

    class ITuplesListsAndFiltersInitializer {
    protected:
        virtual TTupleNameSet GetAdditionalRequiredTuples() const = 0;
        virtual TTupleNameSet GetAdditionalRequiredMergeTuples() const = 0;
    public:
        virtual ~ITuplesListsAndFiltersInitializer() {}

        virtual NOxygen::TTuplesUsageInfo BuildTuplesInfo(bool forMerge) const = 0;
        virtual TTupleNameSet BuildFilterTuples(TRTYOxyConfig::TFilterType filterType) const final;

        virtual const TRTYServerConfig& GetConfig() const = 0;
    };

public:
    TTuplesListsAndFilters(const ITuplesListsAndFiltersInitializer& initializer);
    const TTupleNameSet& GetFilterTuples() const;
    const NOxygen::TTuplesUsageInfo& GetRequiredTuples(bool forMerge) const;
    const TTupleNameSet* GetFilterTuples(const TString& layer) const;
    const TSet<TString>& GetLayersSet() const;
    const TString& GetLayerForMerge() const;
    bool GetHasFullCoverage() const;

private:
    typedef TVector<TTupleNameSet> TFilterTuples;
    typedef THashMap<TString, TTupleNameSet> TFilteredTuplesByLayer;

private:
    static const TTupleNameSet EmptyTupleList;
    TSet<TString> Layers;
    TFilterTuples FilterTuples;
    TFilteredTuplesByLayer FilteredTuplesByLayer;
    NOxygen::TTuplesUsageInfo TuplesForMergeInfo;
    NOxygen::TTuplesUsageInfo TuplesForIndexInfo;
    TString LayerForMerge;
    bool HasFullCoverage;
};
