#pragma once

#include "normalizer.h"

#include <saas/rtyserver/components/oxy/processors/tuples_list_and_filters.h>

class TOXYSlnNormalizer : public NRTYServer::TOxygenNormalizer {
public:
    TOXYSlnNormalizer(const TRTYServerConfig& config, const THolder<TTuplesListsAndFilters>& tuplesListsAndFilters);

    virtual const char* Name() const override;
    virtual bool AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& /* indexFrq */) const override;
    virtual void Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& /* indexFrq */) const override;

private:
    bool HasPruning(const NOxygen::TOxygenOptions* oxygenOptions) const;

private:
    const THolder<TTuplesListsAndFilters>& TuplesListsAndFilters;
};
