#pragma once

#include <saas/rtyserver/components/oxy/normalizer.h>

//
// This class is responsible for convertations between various kinds of KeyInv
//
class TOXYKeyInvNormalizer : public NRTYServer::TOxygenNormalizer {
public:
    using NRTYServer::TOxygenNormalizer::TOxygenNormalizer;

    virtual const char *Name() const override;

    virtual bool AllRight(const NRTYServer::TNormalizerContext &context, const THolder<TFileMap> &indexFrq) const override;

    virtual void Fix(const NRTYServer::TNormalizerContext &context, const THolder<TFileMap> &indexFrq) const override;

public:
    class TIndexTraits final {
    public:
        bool GlobalKeyInv = false;  // index<key|inv> must be present
        bool RenamedGlobalKeyInv = false; // indexold<key|inv> must be present
        bool IndexAttrsOld = false; // indexattrs<key|inv> is present (so it may be used as a source for wrangling)
        bool IndexAttrs = false; // indexattrs.wad must be present
        bool TextWad = false; // indexkeyinv.wad must be present
    };

public:
    static TIndexTraits GetIndexTraits(const NOxygen::TOxygenOptions *oxygenOptions);
    static TIndexTraits GetIndexTraits(const TFsPath dir);
    static bool CheckTraits(const TIndexTraits& expected, const TIndexTraits& actual);
    static bool TryFixByRenaming(const TIndexTraits& expected, TIndexTraits& actual, const TFsPath dir);
    bool TryFixByWrangling(const TIndexTraits& expected, TIndexTraits& actual, const TFsPath dir) const;
    bool DoFix(const TIndexTraits& expected, TIndexTraits& actual, const TFsPath dir) const;
};
