#include "merger.h"

#include <saas/rtyserver/model/component.h>

#include <ysite/yandex/erf/tf.h>

bool TYandLengthsMerger::DoMerge(const NRTYServer::TMergeContext& context, const TRTYServerConfig&) {
    for (auto&& destination : context.Context.Dests) {
        const TFsPath& prefix = TFsPath(destination) / "index";

        TYndex4Searching index;
        index.InitSearch(prefix);
        SaveYandLengths(index, prefix.c_str(), /*nofrq=*/true, /*check=*/true, /*notf=*/false, /*noerf=*/true);
    }
    return true;
}

bool TYandLengthsMerger::DoInitialize() {
    return true;
}

TYandLengthsMerger::TFactory::TRegistrator<TYandLengthsMerger> TYandLengthsMerger::Registrator("TYandLengthsProcessor");
