#include "builder.h"
#include "core.h"

namespace NRTYServer {
    TPropBuilder::TPropBuilder(const TString& componentName, const TString& entityName, IIndexComponentManager* manager, IL2ComponentCore::TPtr core)
        : TL2ComponentBuilder(componentName, entityName, manager, core)
        , Config(dynamic_cast<TPropCore &>(*core).GetConfig())
    {}

    bool TPropBuilder::DoWriteMeta(NRTYServer::TIndexMetadata& metadata) const {
        metadata.SetPropConfig(Config->PropertyNamesToString());
        return true;
    }
}
