#include "component.h"

#include <util/generic/hash_set.h>

namespace NRTYServer {
    bool TPropComponent::DoMergeMeta(const TMergeContext& context) const {
        THashSet<TString> configs;

        for (auto&& source : context.Context.Sources) {
            const TIndexMetadataProcessor meta(source);
            configs.insert(meta->GetPropConfig());
        }
        // Assume the worst when the config has changed between the segments.
        if (configs.size() == 1) {
            const auto& theConfig = *configs.begin();
            for (auto&& destination : context.Context.Dests) {
                TIndexMetadataProcessor meta(destination);
                meta->SetPropConfig(theConfig);
            }
        }
        return TL2ComponentBase::DoMergeMeta(context);
    }
}
