#include "config.h"
#include "globals.h"

#include <util/stream/str.h>
#include <util/string/join.h>
#include <util/string/split.h>

namespace NRTYServer {
    void TPropConfig::DoInit(const TYandexConfig::Section& componentSection) {
        StringSplitter(componentSection.GetDirectives().Value<TString>("Properties"))
            .Split(' ')
            .Collect(&PropertyNames);
        IncludeAll = PropertyNames.contains("*");
        TL2ComponentConfig::DoInit(componentSection);
        EnableFsgta = componentSection.GetDirectives().Value<bool>("EnableFsgta");
        EnableGta = componentSection.GetDirectives().Value<bool>("EnableGta");
        EnableNormalizer = componentSection.GetDirectives().Value<bool>("EnableNormalizer", true);
    }

    void TPropConfig::DoToString(IOutputStream& so) const {
        so << "Properties: " << PropertyNamesToString() << '\n';
        so << "EnableFsgta: " << EnableFsgta << '\n';
        so << "EnableGta: " << EnableGta << '\n';
        so << "EnableNormalizer: " << EnableNormalizer << '\n';
        TL2ComponentConfig::DoToString(so);
    }

    bool TPropConfig::ShouldContainProperty(TStringBuf name) const {
        return IncludeAll || PropertyNames.contains(name);
    }

    TString TPropConfig::PropertyNamesToString() const {
        TVector<TStringBuf> names(PropertyNames.begin(), PropertyNames.end());
        Sort(names);
        return JoinSeq(" ", names);
    }
}
