#pragma once

#include <saas/library/daemon_base/module/module.h>
#include <saas/rtyserver/config/config.h>
#include <saas/rtyserver/components/l2/l2_config.h>

#include <util/generic/hash.h>

namespace NRTYServer {
    class TPropConfig final : public TL2ComponentConfig {
    public:
        using TL2ComponentConfig::ToString;

        bool ShouldContainProperty(TStringBuf name) const;
        TString PropertyNamesToString() const;
        bool GetEnableFsgta() const { return EnableFsgta; }
        bool GetEnableGta() const { return EnableGta; }
        bool GetEnableNormalizer() const { return EnableNormalizer; }

    protected:
        void DoInit(const TYandexConfig::Section& componentSection) override;
        void DoToString(IOutputStream& so) const override;

    private:
        THashSet<TString> PropertyNames;
        bool IncludeAll = false;
        bool EnableFsgta = false;
        bool EnableGta = false;
        bool EnableNormalizer = true;
    };
}
