#include "core.h"

#include "fb_writer.h"

namespace NRTYServer {
    TPropParser::TPropParser(IL2ComponentCore::TPtr core)
        : TL2ComponentParserBase(core)
        , Config(dynamic_cast<const TPropCore&>(*core).GetConfig())
    {
        CHECK_WITH_LOG(Config);
    }

    void TPropParser::Parse(TParsingContext& context) const {
        if (auto entity = GetComponentEntity(context)) {
            WriteRawData(entity, context, WriteDocumentFlatbuffer(context.Document, *Config));
        }
    }

    void TPropCore::Init(const TRTYServerConfig& config) {
        Config = config.ComponentsConfig.Get<TPropConfig>(PropComponentName);
        CHECK_WITH_LOG(Config);
    }
}
