#pragma once

#include "config.h"
#include "builder.h"
#include "disk_manager.h"
#include "globals.h"
#include "memory_manager.h"
#include "normalizer.h"

#include <saas/rtyserver/components/l2/l2_parser.h>
#include <saas/rtyserver/components/l2/l2_manager.h>
#include <saas/rtyserver/components/l2/l2_core.h>
#include <saas/rtyserver/components/l2/l2_builder.h>
#include <saas/rtyserver/components/l2/l2_normalizer.h>

namespace NRTYServer {
    class TPropParser: public TL2ComponentParserBase {
    public:
        explicit TPropParser(IL2ComponentCore::TPtr core);

        void Parse(TParsingContext& context) const override;

    private:
        const TPropConfig* Config;
    };

    class TPropCore final : public IL2ComponentCore {
    public:
        using TDiskManager = TPropDiskManager;
        using TMemoryManager = TPropMemoryManager;
        using TBuilder = TPropBuilder;
        using TDocEntity = TRTYFullArchiveLightEntity;
        using TParser = TPropParser;
        using TNormalizer = TPropNormalizer;

        TStringBuf GetName() const override {
            return PropComponentName;
        }

        bool SupportsMemorySearch() const override {
            return true;
        }

        const TPropConfig* GetConfig() const { return Config; }

        void Init(const TRTYServerConfig& config) override;

    private:
        const TPropConfig* Config = nullptr;
    };
} // namespace NRTYServer
