#pragma once

#include "config.h"

#include <saas/rtyserver/indexer_core/abstract_model.h>

#include <functional>

namespace NRTYServer {
    class IPropManager {
    public:
        virtual ~IPropManager() = default;
        virtual void WalkDocumentProperties(
                ui32 docId, std::function<void (TStringBuf, TStringBuf)>&& cont) const = 0;
        virtual const TPropConfig* GetConfig() const = 0;
    };

    template <class TBase>
    class TPropManagerBase: public TBase, public IPropManager {
    public:
        using TBase::TBase;

        ERTYSearchResult DoSearch(const TRTYSearchRequestContext& context, ICustomReportBuilder& reportBuilder, const IIndexController& controller) const override;
        const TPropConfig* GetConfig() const override;
    };
}
