#include "memory_manager.h"

#include "core.h"

#include <saas/rtyserver/components/fullarchive/globals.h>
#include <saas/rtyserver/components/fullarchive/parsed_entity.h>
#include <saas/rtyserver/components/indexer/index_parsed_entity.h>

namespace NRTYServer {
    void TPropMemoryManager::WalkDocumentProperties(
            ui32 docId, std::function<void (TStringBuf, TStringBuf)>&& cont) const {
        const auto doc = GetParsedDocument(docId);
        if (!doc) {
            return;
        }
        const auto& config = *static_cast<const TPropCore *>(GetCore())->GetConfig();

        if (auto entity = doc->GetComponentEntity<TRTYFullArchiveParsedEntity>(FULL_ARCHIVE_COMPONENT_NAME)) {
            for (const auto& prop: entity->GetDocument().GetDocumentProperties()) {
                if (config.ShouldContainProperty(prop.GetName())) {
                    cont(prop.GetName(), prop.GetValue());
                }
            }
        } else if (auto entity = doc->GetComponentEntity<TIndexParsedEntity>(INDEX_COMPONENT_NAME)) {
            for (const auto& [name, attr]: entity->GetDocumentProperties()) {
                if (config.ShouldContainProperty(name)) {
                    Y_ENSURE(
                            attr.Values.size() == 1,
                            "Property " << name << " has non-unit number of values: " << attr.Values.size());
                    cont(name, attr.Values[0]);
                }
            }
        }
    }
}
