#pragma once

#include "config.h"

#include <saas/rtyserver/components/l2/l2_core.h>
#include <saas/rtyserver/indexer_core/normalizer.h>

namespace NRTYServer {
    class TPropNormalizer : public NRTYServer::INormalizer {
    public:
        TPropNormalizer(const TString& name, IL2ComponentCore::TPtr core, const TRTYServerConfig& config, const TL2DocStorageParams& arcParams);

        virtual const char* Name() const override;
        virtual bool AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& /* indexFrq */) const override;
        virtual void Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& /* indexFrq */) const override;

        TMaybe<ui32> GetNormalizerVersion(const TIndexMetadata& meta) const;

    private:
        size_t FixFromFullarc(const NRTYServer::TNormalizerContext& context) const;
        size_t FixFromTarc(const NRTYServer::TNormalizerContext& context) const;
        const TPropConfig* Config;
    };
} // namespace NRTYServer
